//Revised: September 18, 2008

#include "Mod.h"

using namespace std;

Mod::Mod(const char * _name, const char * _type, const char * _con, const char * _group) {
	this->_name = new char[strlen(_name) + 1];
	strcpy(this->_name, _name);
	
	this->_type = new char[strlen(_type) + 1];
	strcpy(this->_type, _type);

	this->_con = new char[strlen(_con) + 1];
	strcpy(this->_con, _con);

	this->_group = new char[strlen(_group) + 1];
	strcpy(this->_group, _group);
}

Mod::Mod(const Mod & x) {
	this->_name = new char[strlen(x._name) + 1];
	strcpy(this->_name, x._name);
	
	this->_type = new char[strlen(x._type) + 1];
	strcpy(this->_type, x._type);
	
	this->_con = new char[strlen(x._con) + 1];
	strcpy(this->_con, x._con);

	this->_group = new char[strlen(x._group) + 1];
	strcpy(this->_group, x._group);
}

Mod & Mod::operator = (const Mod & x) {
	delete [] this->_name;
	delete [] this->_type;
	delete [] this->_con;
	delete [] this->_group;

	this->_name = new char[strlen(x._name) + 1];
	strcpy(this->_name, x._name);

	this->_type = new char[strlen(x._type) + 1];
	strcpy(this->_type, x._type);

	this->_con = new char[strlen(x._con) + 1];
	strcpy(this->_con, x._con);

	this->_group = new char[strlen(x._group) + 1];
	strcpy(this->_group, x._group);

	return *this;
}

Mod::~Mod(void) {
	delete [] _name;
	delete [] _type;
	delete [] _con;
	delete [] _group;
}

void Mod::name(const char * _name) {
	this->_name = new char[strlen(_name) + 1];
	strcpy(this->_name, _name);
}

void Mod::type(const char * _type) {
	this->_type = new char[strlen(_type) + 1];
	strcpy(this->_type, _type);
}

void Mod::con(const char * _con) {
	this->_con = new char[strlen(_con) + 1];
	strcpy(this->_con, _con);
}

void Mod::group(const char * _group) {
	this->_group = new char[strlen(_group) + 1];
	strcpy(this->_group, _group);
}

char * Mod::name() const  { return this->_name; }
char * Mod::type() const  { return this->_type; }
char * Mod::con() const   { return this->_con; }
char * Mod::group() const { return this->_group; }

bool Mod::operator == (const Mod & x) const {
	return strcasecmp(this->_name, x._name) == 0;
}

bool Mod::operator != (const Mod & x) const {
	return !operator == (x);
}

void Mod::printOn(ostream & o) const {
	o << this->_name;
}

ostream & operator << (ostream & o, const Mod & x) {
	x.printOn(o);
	return o;
}
